Rem
Rem $Header: rdbms/demo/rac_wrappers/enq.sql /main/1 2009/11/12 21:46:15 swshekha Exp $
Rem
Rem enq.sql
Rem
Rem Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      enq.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sswaroop    11/12/09 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

set echo on
set serveroutput on


CREATE OR REPLACE PROCEDURE DEMO_ENQUEUE (userinfo message,
                                          priority number) AS

    recipients          DBMS_AQ.aq$_recipient_list_t;
    enq_msgid     RAW(16);
    eopt                dbms_aq.enqueue_options_t;
    mprop               dbms_aq.message_properties_t;
BEGIN
    mprop.priority := priority;
    dbms_aq.enqueue(
        queue_name => 'input_queue',
        enqueue_options => eopt,
        message_properties => mprop,
        payload => userinfo,
        msgid => enq_msgid);
    commit;
END demo_enqueue;
/
show errors;

DECLARE
    payload message;
    city1 varchar2(30) := 'BELMONT';
    city2 varchar2(30) := 'REDWOOD SHORES';
    city3 varchar2(30) := 'SUNNYVALE';
    city4 varchar2(30) := 'BURLINGAME';
BEGIN
    for i in 1..10 LOOP
            IF mod (i, 3) = 0 THEN
                payload := message(i, city1, mod(i, 3) + 1);
            ELSIF mod(i, 4) = 0 THEN
                payload := message(i, city2, mod(i, 3) + 1);
            ELSIF mod(i, 2) = 0 THEN
                payload := message(i, city3, mod(i, 3) + 1);
            ELSE
                payload := message(i, city4, mod(i, 3) + 1);
            END IF;
            demo_enqueue(payload, (mod(i, 3) + 1));
 END LOOP;
END;
/


